/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Context;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LightRetained;
import javax.media.j3d.Pipeline;
import javax.media.j3d.PointLightRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Vector3f;

class SpotLightRetained
extends PointLightRetained {
    static final int DIRECTION_CHANGED = 512;
    static final int ANGLE_CHANGED = 1024;
    static final int CONCENTRATION_CHANGED = 2048;
    Vector3f direction = new Vector3f(0.0f, 0.0f, -1.0f);
    Vector3f xformDirection = new Vector3f(0.0f, 0.0f, -1.0f);
    float spreadAngle = (float)Math.PI;
    float concentration = 0.0f;

    SpotLightRetained() {
        this.nodeType = 8;
        this.lightType = 4;
    }

    void initSpreadAngle(float f2) {
        this.spreadAngle = (double)f2 < 0.0 ? 0.0f : (f2 > 1.5707964f ? (float)Math.PI : f2);
    }

    void setLive(SetLiveState setLiveState) {
        super.doSetLive(setLiveState);
        J3dMessage j3dMessage = super.initMessage(12);
        Object[] objectArray = (Object[])j3dMessage.args[4];
        objectArray[9] = new Float(this.spreadAngle);
        objectArray[10] = new Float(this.concentration);
        objectArray[11] = new Vector3f(this.direction);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void setSpreadAngle(float f2) {
        this.initSpreadAngle(f2);
        this.sendMessage(1024, new Float(this.spreadAngle));
    }

    float getSpreadAngle() {
        return this.spreadAngle;
    }

    void initConcentration(float f2) {
        this.concentration = f2;
    }

    void setConcentration(float f2) {
        this.initConcentration(f2);
        this.sendMessage(2048, new Float(f2));
    }

    float getConcentration() {
        return this.concentration;
    }

    void initDirection(Vector3f vector3f) {
        this.direction.set(vector3f);
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.direction, this.direction);
        }
    }

    void setDirection(Vector3f vector3f) {
        this.initDirection(vector3f);
        this.sendMessage(512, new Vector3f(vector3f));
    }

    void initDirection(float f2, float f3, float f4) {
        this.direction.x = f2;
        this.direction.y = f3;
        this.direction.z = f4;
        if (this.staticTransform != null) {
            this.staticTransform.transform.transform(this.direction, this.direction);
        }
    }

    void setDirection(float f2, float f3, float f4) {
        this.setDirection(new Vector3f(f2, f3, f4));
    }

    void getDirection(Vector3f vector3f) {
        vector3f.set(this.direction);
        if (this.staticTransform != null) {
            Transform3D transform3D = this.staticTransform.getInvTransform();
            transform3D.transform(vector3f, vector3f);
        }
    }

    void update(Context context, int n2, double d2) {
        this.validateAttenuationInEc(d2);
        Pipeline.getPipeline().updateSpotLight(context, n2, this.color.x, this.color.y, this.color.z, this.attenuation.x, this.linearAttenuationInEc, this.quadraticAttenuationInEc, this.xformPosition.x, this.xformPosition.y, this.xformPosition.z, this.spreadAngle, this.concentration, this.xformDirection.x, this.xformDirection.y, this.xformDirection.z);
    }

    void updateMirrorObject(Object[] objectArray) {
        int n2 = (Integer)objectArray[1];
        int n3 = (Integer)objectArray[2];
        LightRetained[] lightRetainedArray = (LightRetained[])objectArray[3];
        if ((n2 & 0x200) != 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (lightRetainedArray[i2].nodeType != 8) continue;
                SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetainedArray[i2];
                spotLightRetained.direction = (Vector3f)objectArray[4];
                spotLightRetained.getLastLocalToVworld().transform(spotLightRetained.direction, spotLightRetained.xformDirection);
                spotLightRetained.xformDirection.normalize();
            }
        } else if ((n2 & 0x400) != 0) {
            for (int i3 = 0; i3 < n3; ++i3) {
                if (lightRetainedArray[i3].nodeType != 8) continue;
                SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetainedArray[i3];
                spotLightRetained.spreadAngle = ((Float)objectArray[4]).floatValue();
            }
        } else if ((n2 & 0x800) != 0) {
            for (int i4 = 0; i4 < n3; ++i4) {
                if (lightRetainedArray[i4].nodeType != 8) continue;
                SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetainedArray[i4];
                spotLightRetained.concentration = ((Float)objectArray[4]).floatValue();
            }
        } else if ((n2 & 0x20) != 0) {
            for (int i5 = 0; i5 < n3; ++i5) {
                if (lightRetainedArray[i5].nodeType != 8) continue;
                SpotLightRetained spotLightRetained = (SpotLightRetained)lightRetainedArray[i5];
                spotLightRetained.spreadAngle = ((Float)((Object[])objectArray[4])[9]).floatValue();
                spotLightRetained.concentration = ((Float)((Object[])objectArray[4])[10]).floatValue();
                spotLightRetained.direction = (Vector3f)((Object[])objectArray[4])[11];
                spotLightRetained.getLastLocalToVworld().transform(spotLightRetained.direction, spotLightRetained.xformDirection);
                spotLightRetained.xformDirection.normalize();
            }
        }
        super.updateMirrorObject(objectArray);
    }

    protected Object clone() {
        SpotLightRetained spotLightRetained = (SpotLightRetained)super.clone();
        spotLightRetained.direction = new Vector3f(this.direction);
        spotLightRetained.xformDirection = new Vector3f();
        return spotLightRetained;
    }

    void updateTransformChange() {
        super.updateTransformChange();
        this.getLastLocalToVworld().transform(this.direction, this.xformDirection);
        this.xformDirection.normalize();
    }

    final void sendMessage(int n2, Object object) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 4224;
        j3dMessage.universe = this.universe;
        j3dMessage.type = 19;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n2);
        j3dMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorLights) : new Integer(1);
        j3dMessage.args[3] = this.mirrorLights.clone();
        j3dMessage.args[4] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        transformGroupRetained.transform.transform(this.direction, this.direction);
    }
}

